<?php

namespace app\subcomponents\admissions\models;

use common\models\ApplicantModel;
use common\models\CompulsoryRelationModel;
use frontend\models\StudentRegistration;
use app\subcomponents\admissions\models\StudentRegistration as AdmissionsStudentRegistration;
use app\subcomponents\admissions\models\CapeStudentRegistration;
use common\models\StudentRegistrationModel;
use common\models\UserModel;

class DuplicateStudentAccount
{

    public $username;
    public $fullName;
    public $gender;
    public $dateOfBirth;
    public $nationality;
    public $placeOfBirth;
    public $sponsorName;
    public $beneficiaryDetails;
    public $displayPicture;
    public $studentRegistrations;


    public function __construct(
        $username,
        $fullName,
        $gender,
        $dateOfBirth,
        $nationality,
        $placeOfBirth,
        $sponsorName,
        $beneficiaryDetails,
        $displayPicture,
        $studentRegistrations
    ) {
        $this->username = $username;
        $this->fullName = $fullName;
        $this->gender = $gender;
        $this->dateOfBirth = $dateOfBirth;
        $this->nationality = $nationality;
        $this->placeOfBirth = $placeOfBirth;
        $this->sponsorName = $sponsorName;
        $this->beneficiaryDetails = $beneficiaryDetails;
        $this->displayPicture = $displayPicture;
        $this->studentRegistrations = $studentRegistrations;
    }


    /**
     * DuplicateStudentAccount factory method
     *
     * @param string $username
     * @return DuplicateStudentAccount
     */
    public static function create($username)
    {
        $customer = UserModel::findUserByUsername($username);
        $userFullName = UserModel::getUserFullname($customer);
        $applicant = ApplicantModel::getApplicantByPersonid($customer->personid);
        $beneficiaryDetails =
            CompulsoryRelationModel::getBeneficiarySummary($customer);

        $displayPicture = ApplicantModel::generateDisplayPicture($applicant);

        $studentRegistrationTranscripts = array();
        $registrations =
            StudentRegistrationModel::getRegistrationsByPersonId($applicant->personid);

        foreach ($registrations as $registration) {
            $isCape =
                StudentRegistration::isCape(
                    $registration->studentregistrationid
                );
            if ($isCape == false) {
                array_push(
                    $studentRegistrationTranscripts,
                    AdmissionsStudentRegistration::create(
                        $registration->studentregistrationid
                    )
                );
            } else {
                array_push(
                    $studentRegistrationTranscripts,
                    CapeStudentRegistration::create(
                        $registration->studentregistrationid
                    )
                );
            }
        }

        $model = new DuplicateStudentAccount(
            $username,
            $userFullName,
            $applicant->gender,
            $applicant->dateofbirth,
            $applicant->nationality,
            $applicant->placeofbirth,
            $applicant->sponsorname,
            $beneficiaryDetails,
            $displayPicture,
            $studentRegistrationTranscripts
        );
        return $model;
    }
}
