<?php

namespace app\subcomponents\admissions\models;

use common\models\ApplicantModel;
use common\models\Application;
use common\models\ApplicationModel;
use common\models\CompulsoryRelationModel;
use common\models\UserModel;

class DuplicateApplicantAccount
{
    public $username;
    public $fullName;
    public $gender;
    public $dateOfBirth;
    public $nationality;
    public $placeOfBirth;
    public $sponsorName;
    public $beneficiaryDetails;
    public $applicationDetails;
    public $displayPicture;
    public $status;


    public function __construct(
        $username,
        $fullName,
        $gender,
        $dateOfBirth,
        $nationality,
        $placeOfBirth,
        $sponsorName,
        $beneficiaryDetails,
        $applicationDetails,
        $displayPicture,
        $status
    ) {
        $this->username = $username;
        $this->fullName = $fullName;
        $this->gender = $gender;
        $this->dateOfBirth = $dateOfBirth;
        $this->nationality = $nationality;
        $this->placeOfBirth = $placeOfBirth;
        $this->sponsorName = $sponsorName;
        $this->beneficiaryDetails = $beneficiaryDetails;
        $this->applicationDetails = $applicationDetails;
        $this->displayPicture = $displayPicture;
        $this->status = $status;
    }


    public static function create($username, $status)
    {
        $customer = UserModel::findUserByUsername($username);
        $userFullName = UserModel::getUserFullname($customer);
        $applicant = ApplicantModel::getApplicantByPersonid($customer->personid);

        $beneficiaryDetails =
            CompulsoryRelationModel::getBeneficiarySummary($customer);

        $displayPicture = ApplicantModel::generateDisplayPicture($applicant);

        $applications =
            Application::find()
            ->where(
                [
                    "applicationstatusid" => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
                    "personid" => $applicant->personid,
                    "isactive" => 1,
                    "isdeleted" => 0
                ]
            )
            ->orderBy("ordering ASC")
            ->all();
        $applicationDetails =
            ApplicationModel::formatApplicationsInformation($applications);

        return new DuplicateApplicantAccount(
            $username,
            $userFullName,
            $applicant->gender,
            $applicant->dateofbirth,
            $applicant->nationality,
            $applicant->placeofbirth,
            $applicant->sponsorname,
            $beneficiaryDetails,
            $applicationDetails,
            $displayPicture,
            $status
        );
    }
}
