<?php

namespace app\subcomponents\admissions\models;

use Yii;
use common\models\AcademicStatus;
use common\models\ApplicationModel;
use common\models\OfferModel;
use common\models\StudentRegistrationModel;
use common\models\StudentStatus;

class CapeStudentRegistration
{

    public $studentRegistrationId;
    public $programme;
    public $level;
    public $studentStatus;
    public $academicStatus;
    public $semesterTranscripts;
    public $transcriptFields;

    public function __construct(
        $studentRegistrationId,
        $programme,
        $level,
        $studentStatus,
        $academicStatus,
        $semesterTranscripts,
        $transcriptFields
    ) {
        $this->studentRegistrationId = $studentRegistrationId;
        $this->programme = $programme;
        $this->level = $level;
        $this->studentStatus = $studentStatus;
        $this->academicStatus = $academicStatus;
        $this->semesterTranscripts = $semesterTranscripts;
        $this->transcriptFields = $transcriptFields;
    }


    /**
     * CapeStudentRegistration factory method
     *
     * @param integer $studentRegistrationId
     * @return capeStudentRegistration
     */
    public static function create($studentRegistrationId)
    {
        $registration =
            StudentRegistrationModel::getStudentRegistrationByID(
                $studentRegistrationId
            );

        $studentStatus =
            StudentStatus::find()
            ->where([
                "studentstatusid" => $registration->studentstatusid
            ])
            ->one()
            ->name;

        $academicStatus =
            AcademicStatus::find()
            ->where([
                "academicstatusid" => $registration->academicstatusid
            ])
            ->one()
            ->name;

        $transcriptFields = self::getFormattedHtmlTableHeader();

        return new CapeStudentRegistration(
            $studentRegistrationId,
            self::getProgramme($registration),
            $registration->currentlevel,
            $studentStatus,
            $academicStatus,
            self::buildTranscript($studentRegistrationId),
            $transcriptFields
        );
    }


    private static function getFormattedHtmlTableHeader()
    {
        return "<tr>"
            . "<th>Course Code</th>"
            . "<th>Course Name</th>"
            . "<th>Unit</th>"
            . "<th>Subject</th>"
            . "<th>Coursework</th>"
            . "<th>Exam</th>"
            . "<th>Final</th>"
            . "</tr>";
    }


    private static function getProgramme($registration)
    {
        $offer = OfferModel::getOfferById($registration->offerid);
        $application = OfferModel::getApplication($offer);
        return ApplicationModel::getFormattedProgrammeChoice($application);
    }


    private static function buildTranscript($studentRegistrationId)
    {
        $semesterTranscripts = array();

        $courseResults =
            Yii::$app->db->createCommand(
                "SELECT cape_course.coursecode AS 'courseCode',"
                    . " cape_course.name AS 'courseName',"
                    . " batch_student_cape.studentregistrationid As 'studentRegistrationId',"
                    . " batch_student_cape.courseworktotal As 'cw',"
                    . " batch_student_cape.examtotal As 'exam',"
                    . " batch_student_cape.final As 'final',"
                    . " cape_unit.unitcode AS 'unit',"
                    . " cape_subject.subjectname AS 'subject',"
                    . " semester.semesterid AS 'semesterId',"
                    . " semester.title AS 'semesterTitle',"
                    . " academic_year.academicyearid AS 'academicYearId',"
                    . " academic_year.title AS 'academicYearTitle'"
                    . " FROM batch_student_cape"
                    . " JOIN batch_cape"
                    . " ON batch_student_cape.batchcapeid = batch_cape.batchcapeid"
                    . " JOIN cape_course"
                    . " ON batch_cape.capecourseid = cape_course.capecourseid"
                    . " JOIN cape_unit"
                    . " ON cape_course.capeunitid = cape_unit.capeunitid"
                    . " JOIN cape_subject"
                    . " ON cape_unit.capesubjectid = cape_subject.capesubjectid"
                    . " JOIN semester"
                    . " ON cape_course.semesterid = semester.semesterid"
                    . " JOIN academic_year"
                    . " ON semester.academicyearid = academic_year.academicyearid"
                    . " WHERE batch_student_cape.studentregistrationid = {$studentRegistrationId}"
                    . " AND batch_student_cape.isactive = 1"
                    . " AND batch_student_cape.isdeleted = 0"
                    . " ORDER BY semester.semesterid DESC, cape_course.coursecode ASC;"
            )
            ->queryAll();

        if (empty($courseResults) == true) {
            return $semesterTranscripts;
        }

        $uniqueSemesterIds = array();
        $previousSemesterTranscript = null;
        $semesterTranscript = null;
        foreach ($courseResults as $courseResult) {
            $semesterId = $courseResult["semesterId"];
            if (in_array($semesterId, $uniqueSemesterIds) == false) {
                array_push($uniqueSemesterIds, $semesterId);
                if ($previousSemesterTranscript != null) {
                    array_push($semesterTranscripts, $previousSemesterTranscript);
                }
                $semesterTranscript = CapeSemesterTranscript::create($courseResult);
            }
            $semesterTranscript->addGrade($courseResult);
            $previousSemesterTranscript = $semesterTranscript;
        }

        array_push($semesterTranscripts, $semesterTranscript);
        return $semesterTranscripts;
    }
}
