<?php

namespace app\subcomponents\admissions\models;

class CapeSemesterTranscript
{

    public $semesterId;
    public $label;
    public $grades;


    public function __construct($semesterId, $label)
    {
        $this->semesterId = $semesterId;
        $this->label = $label;
        $this->grades = array();
    }


    /**
     * SemesterTranscript factory method
     *
     * @param array $courseResult
     * @return CapeSemesterTranscript
     */
    public static function create($courseResult)
    {
        $semesterId = $courseResult["semesterId"];

        $academicYearTitle = $courseResult["academicYearTitle"];
        $semesterTitle = $courseResult["semesterTitle"];
        $label =
            "<h4>Academic Year: {$academicYearTitle}, Semester: {$semesterTitle}</h4>";

        return new CapeSemesterTranscript($semesterId, $label);
    }


    /**
     * Undocumented function
     *
     * @param array $courseResult
     * @return void
     */
    public function addGrade($courseResult)
    {
        array_push(
            $this->grades,
            CapeGrade::createGradeFromCourseResultArray($courseResult)
        );
    }
}
