<?php

namespace app\subcomponents\admissions\models;

class CapeGrade
{
    public $courseCode;
    public $courseName;
    public $unit;
    public $subject;
    public $courseworkMarks;
    public $examMarks;
    public $finalMarks;

    public function __construct(
        $courseCode,
        $courseName,
        $unit,
        $subject,
        $courseworkMarks,
        $examMarks,
        $finalMarks
    ) {
        $this->courseCode = $courseCode;
        $this->courseName = $courseName;
        $this->unit = $unit;
        $this->subject = $subject;
        $this->courseworkMarks = $courseworkMarks;
        $this->examMarks = $examMarks;
        $this->finalMarks = $finalMarks;
    }


    /**
     * Grade Factory method
     *
     * @param array $capeCourseResult
     * @return Grade
     */
    public static function createGradeFromCourseResultArray($capeCourseResult)
    {
        return new CapeGrade(
            $capeCourseResult["courseCode"],
            $capeCourseResult["courseName"],
            $capeCourseResult["unit"],
            $capeCourseResult["subject"],
            $capeCourseResult["cw"],
            $capeCourseResult["exam"],
            $capeCourseResult["final"]
        );
    }


    /**
     * Returns model as an HTML table row element
     *
     * @return string
     */
    public function toHtmlTableRowElement()
    {
        return "<tr>"
            . "<td>{$this->courseCode}</td>"
            . "<td>{$this->courseName}</td>"
            . "<td>{$this->unit}</td>"
            . "<td>{$this->subject}</td>"
            . "<td>{$this->courseworkMarks}</td>"
            . "<td>{$this->examMarks}</td>"
            . "<td>{$this->finalMarks}</td>"
            . "</tr>";
    }
}
