<?php

namespace app\subcomponents\admissions\controllers;

use app\subcomponents\admissions\models\DuplicateApplicantAccount;
use app\subcomponents\admissions\models\DuplicateStudentAccount;
use common\models\UserModel;

class DuplicateAccountsController extends \yii\web\Controller
{
    public function actionPreviewAccount($username)
    {
        $customer =
            UserModel::findUserByApplicantIdPotentialStudentIdOrStudentId(
                $username
            );

        $customerClassification =
            UserModel::getUserClassification($customer);

        if ($customerClassification == "Student") {
            return $this->redirect([
                "preview-student-account",
                "username" => $username
            ]);
        } elseif ($customerClassification == "Successful Applicant") {
            return $this->redirect([
                "preview-applicant-account",
                "username" => $username,
                "status" => "Unenrolled Successful Applicant"
            ]);
        } elseif ($customerClassification == "Completed Applicant") {
            return $this->redirect([
                "preview-applicant-account",
                "username" => $username,
                "status" => "Completed Applicant"
            ]);
        } elseif ($customerClassification == "Abandoned Applicant") {
            return $this->redirect([
                "preview-applicant-account",
                "username" => $username,
                "status" => "Applicant's Application Removed"
            ]);
        } elseif ($customerClassification == "Incomplete Applicant") {
            return $this->redirect(
                [
                    "preview-applicant-account",
                    "username" => $customer->username,
                    "status" => "Applicant's Application Incomplete"
                ]
            );
        }
    }


    public function actionPreviewApplicantAccount($username, $status)
    {
        $profile = DuplicateApplicantAccount::create($username, $status);

        return $this->render(
            "preview-applicant-account",
            ["model" => $profile]
        );
    }


    public function actionPreviewStudentAccount($username)
    {
        $profile = DuplicateStudentAccount::create($username);

        return $this->render(
            "preview-student-account",
            ["model" => $profile]
        );
    }
}
