<?php

namespace frontend\core\usecases;

use app\subcomponents\bursary\views\viewmodels\registryandlibraryservices\RegistryAndLibraryFeesViewModel;

use frontend\core\domain\exceptions\ApplicationException;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driver\registryandlibraryservices\ViewRegistryAndLibraryFeesResponse;

/**
 * Genrate form for payment of registry and library fees
 */
class ViewRegistryAndLibraryFeesUseCase
{
    private $studentRegistrationRepository;
    private $applicationPeriodRepository;
    private $userRepository;
    private $studentRepository;
    private $billingChargeRepository;
    private $paymentMethodRepository;


    /**
     * Class constructor
     *
     * @param StudentRegistrationRepository $studentRegistrationRepository
     * @param ApplicationPeriodRepository $applicationPeriodRepository
     * @param UserRepository $userRepository
     * @param StudentRepository $studentRepository
     * @param BillingChargeRepository $billingChargeRepository
     * @param PaymentMethodRepository $paymentMethodRepository
     */
    public function __construct(
        $studentRegistrationRepository,
        $applicationPeriodRepository,
        $userRepository,
        $studentRepository,
        $billingChargeRepository,
        $paymentMethodRepository
    ) {
        $this->studentRegistrationRepository = $studentRegistrationRepository;
        $this->applicationPeriodRepository = $applicationPeriodRepository;
        $this->userRepository = $userRepository;
        $this->studentRepository = $studentRepository;
        $this->billingChargeRepository = $billingChargeRepository;
        $this->paymentMethodRepository = $paymentMethodRepository;
    }


    /**
     * Generate view model for service fee form payment
     *
     * @param ViewRegistryAndLibraryFeesRequest $request
     * @return ViewRegistryAndLibraryFeesResponse
     * @throws ApplicationException
     */
    public function generateFeesForm($request)
    {
        try {
            $registryAndLibraryFeesViewModel =
                RegistryAndLibraryFeesViewModel::create(
                    $request->studentRegistrationId,
                    $this->studentRegistrationRepository,
                    $this->applicationPeriodRepository,
                    $this->userRepository,
                    $this->studentRepository,
                    $this->billingChargeRepository,
                    $this->paymentMethodRepository,
                    $request->personnelId

                );
        } catch (ModelNotFoundException $ex) {
            throw new ApplicationException(500, $ex->message);
        }

        return ViewRegistryAndLibraryFeesResponse::createSuccessResponse(
            $registryAndLibraryFeesViewModel
        );
    }
}
