<?php

namespace frontend\core\usecases;

use frontend\core\domain\exceptions\ApplicationException;
use frontend\core\ports\driver\registryandlibraryservices\PublishReceiptResponse;

/**
 * Use case to generate and send email containing Receipt file to client.
 */
class PublishReceiptUseCase
{
    private $forPublishingReceipt;
    private $receiptRepository;


    /**
     * Class constructor
     *
     * @param ForPublishingReceipt $forPublishingReceipt
     * @param ReceiptRepository $receiptRepository
     */
    public function __construct($forPublishingReceipt, $receiptRepository)
    {
        $this->forPublishingReceipt = $forPublishingReceipt;
        $this->receiptRepository = $receiptRepository;
    }


    /**
     * Processes email publishing request of receipt.
     * 
     * Retrieves receipt model from database, retrieves receipt file from 
     * directory, generate email, attaches file to email and sends email.
     *
     * @param PublishReceiptRequest $request
     * @return PublishReceiptResponse
     * @throws ApplicationException
     */
    public function publishReceipt($request)
    {
        $receiptEntity = $this->receiptRepository->find($request->receiptId);
        try {
            $this->forPublishingReceipt->publishReceipt($receiptEntity);
        } catch (ApplicationException $ex) {
            throw new ApplicationException(500, $ex->message);
        }

        return PublishReceiptResponse::createSuccessResponse(
            $receiptEntity->getId(),
            $receiptEntity->getUsername()
        );
    }
}
