<?php

namespace frontend\core\usecases;

use Yii;
use frontend\core\domain\exceptions\ApplicationException;
use frontend\core\ports\driver\registryandlibraryservices\PreviewPaymentResponse;
use app\subcomponents\bursary\views\viewmodels\registryandlibraryservices\PaymentPreviewFactory;

/**
 * Use case to generate preview of registry and library fee transaction submission
 */
class PreviewStudentServiceFeePaymentUseCase
{
    public $employeeRepository;


    /**
     * Class constructor
     *
     * @param EmployeeRepository $employeeRepository
     */
    public function __construct($employeeRepository)
    {
        $this->employeeRepository = $employeeRepository;
    }


    /**
     * Generate preview of receipt for user submitted payment.
     *
     * @param PreviewPaymentRequest $request
     * @return PreviewPaymentResponse
     * 
     * @throws ApplicationException
     */
    public function generateReceiptPreview($request)
    {
        try {
            $paymentPreview =
                PaymentPreviewFactory::create(
                    $request->userId,
                    $request->registryAndLibraryFeesViewModel,
                    $this->employeeRepository
                );
        } catch (ApplicationException $ex) {
            throw new ApplicationException(500, $ex->message);
        }

        return PreviewPaymentResponse::createSuccessResponse($paymentPreview);
    }
}
