<?php

namespace frontend\core\usecases;

use frontend\core\domain\exceptions\ApplicationException;
use frontend\core\ports\driver\registryandlibraryservices\GenerateReceiptFileResponse;

/**
 * Use case for generating receipt file
 */
class GenerateReceiptFileUseCase
{
    private $forGeneratingReceiptFile;
    private $receiptRepository;


    /**
     * Class constructor
     *
     * @param ForGeneratingReceiptFile $forGeneratingReceiptFile
     * @param ReceiptRepository $receiptRepository
     */
    public function __construct($forGeneratingReceiptFile, $receiptRepository)
    {
        $this->forGeneratingReceiptFile = $forGeneratingReceiptFile;
        $this->receiptRepository = $receiptRepository;
    }

    /**
     * Retrieves ReceiptEntity from request, uses it to generate the receipt
     * document and persists it to the application's file directory.
     * 
     * @param GenerateReceiptFileRequest $request
     * @return GenerateReceiptFileResponse
     */
    public function generateReceiptFile($request)
    {
        $receiptEntity = $this->receiptRepository->find($request->receiptId);
        try {
            $this->forGeneratingReceiptFile->processReceipt($receiptEntity);
        } catch (ApplicationException $ex) {
            throw new ApplicationException(500, $ex->message);
        }

        return GenerateReceiptFileResponse::createSuccessResponse(
            $receiptEntity->getId(),
            $receiptEntity->getUsername()
        );
    }
}
