<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\UserRepository;

/**
 * UserRepository Implementation
 */
class UserRepositoryImp implements UserRepository
{
    private $userStorage;

    /**
     * Class constructor
     *
     * @param UserStorage $userStorage
     */
    public function __construct($userStorage)
    {
        $this->userStorage = $userStorage;
    }


    /**
     * returns user model by $id
     *
     * @param integer $id
     * @return User
     */
    public function getUserById($id)
    {
        return $this->userStorage->getUserById($id);
    }
}
