<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\StudentRepository;

/**
 * Student repository implementation
 */
class StudentRepositoryImp implements StudentRepository
{
    private $studentStorage;


    /**
     * Undocumented function
     *
     * @param StudentStorage $studentStorage
     */
    public function __construct($studentStorage)
    {
        $this->studentStorage = $studentStorage;
    }


    /**
     * Find fullname of student identified by id
     *
     * @param integer $id
     * @return Student
     */
    public function getStudentFullNameByPersonId($id)
    {
        $student = $this->studentStorage->getStudentByPersonId($id);

        if ($student->middlename == null) {
            return "{$student->title} {$student->firstname} {$student->lastname}";
        } else {
            return "{$student->title} "
                . "{$student->firstname} "
                . "{$student->middlename} "
                . "{$student->lastname}";
        }
    }
}
