<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\StudentRegistrationRepository;

/**
 * StudentRegistrationRepository Implementation
 */
class StudentRegistrationRepositoryImp implements StudentRegistrationRepository
{
    private $studentRegistrationStorage;

    /**
     * Class constructor
     *
     * @param StudentRegistrationStorage $studentRegistrationStorage
     */
    public function __construct($studentRegistrationStorage)
    {
        $this->studentRegistrationStorage = $studentRegistrationStorage;
    }

    /**
     * Returns student registration model based on id
     *
     * @param integer $id
     * @return StudentRegistration
     */
    public function getStudentRegistrationById($id)
    {
        return $this->studentRegistrationStorage->getStudentRegistrationById($id);
    }
}
