<?php

namespace frontend\core\services;

/**
 * Generates receipts numbers
 */
class ReceiptNumberGenerator
{
    private function __construct()
    {
    }


    /**
     * Create receipt number based on date
     *
     * @return void
     */
    public static function create()
    {
        $unformattedDate = date('Y-m-d');
        $yearSegment = substr($unformattedDate, 0, 4);
        $monthSegment = substr($unformattedDate, 5, 2);
        $daySegment = substr($unformattedDate, 8, 2);
        $idSegment = self::generateIdSegment();
        return "{$yearSegment}{$monthSegment}{$daySegment}{$idSegment}";
    }


    private static function padToFourCharacterString($numAsString)
    {
        $length = strlen($numAsString);
        if ($length == 1) {
            return "000{$numAsString}";
        } elseif ($length == 2) {
            return "00{$numAsString}";
        } elseif ($length == 3) {
            return "0{$numAsString}";
        } elseif ($length == 4) {
            return $numAsString;
        }
    }


    private static function generateIdSegment()
    {
        $number = rand(0, 9999);
        $numberAsFourCharacterString = strval($number);
        return self::padToFourCharacterString($numberAsFourCharacterString);
    }
}
