<?php

namespace frontend\core\services;

use frontend\core\ports\driven\ReceiptDto;
use frontend\core\domain\bursary\BillingEntity;
use frontend\core\domain\bursary\ReceiptEntity;

/**
 * Handles conversion between entities and DTO models for Receipts
 */
class ReceiptConverter
{
    private function __construct()
    {
    }


    /**
     * Convert Billing DTO to Billing Entity
     *
     * @param ReceiptEntity $receiptEntity
     * @return ReceiptDto
     */
    public static function toDto($receiptEntity)
    {
        return new ReceiptDto(
            $receiptEntity->getId(),
            $receiptEntity->getPaymentMethod(),
            $receiptEntity->getCustomerId(),
            $receiptEntity->getStudentRegistrationId(),
            $receiptEntity->getCreatorId(),
            $receiptEntity->getModifierId(),
            $receiptEntity->getUsername(),
            $receiptEntity->getFullName(),
            $receiptEntity->getReceiptNumber(),
            $receiptEntity->getEmail(),
            $receiptEntity->getNotes(),
            $receiptEntity->getPublishCount(),
            $receiptEntity->getAutoPublish(),
            $receiptEntity->getDatePaid(),
            $receiptEntity->getCreatedTimestamp(),
            $receiptEntity->getIsActive(),
            $receiptEntity->getIsDeleted(),
            $receiptEntity->getChequeNumber(),
            $receiptEntity->getLastModifiedTimestamp(),
            $receiptEntity->getTotal(),
            $receiptEntity->getPersonnelCode()
        );
    }


    /**
     * Convert Billing Entity to Billing DTO
     *
     * @param ReceiptDto $receiptDto
     * @return ReceiptEntity
     */
    public static function toEntity($receiptDto)
    {
        $receiptEntity =
            ReceiptEntity::defaultConstructor(
                $receiptDto->paymentMethod,
                $receiptDto->customerId,
                $receiptDto->studentRegistrationId,
                $receiptDto->creatorId,
                $receiptDto->modifierId,
                $receiptDto->username,
                $receiptDto->fullName,
                $receiptDto->receiptNumber,
                $receiptDto->email,
                $receiptDto->notes,
                $receiptDto->publishCount,
                $receiptDto->autoPublish,
                $receiptDto->datePaid,
                $receiptDto->createdTimestamp,
                $receiptDto->isActive,
                $receiptDto->isDeleted,
                $receiptDto->chequeNumber,
                $receiptDto->lastModifiedTimestamp
            );
        $receiptEntity->setId($receiptDto->id);
        return $receiptEntity;
    }


    /**
     * Builds receipt aggregate
     *
     * @param ReceiptDto $receiptDto
     * @param BillingDtos[] $billingDtos
     * @return ReceiptEntity
     */
    public static function toEntityAggregate($receiptDto, $billingDtos)
    {
        $billingEntities = array();
        foreach ($billingDtos as $billingDto) {
            array_push(
                $billingEntities,
                BillingEntity::allArgsConstructor(
                    $billingDto->id,
                    $billingDto->paymentMethod,
                    $billingDto->billingCharge,
                    $billingDto->billingChargeId,
                    $billingDto->customerId,
                    $billingDto->studentRegistrationId,
                    $billingDto->academicOfferingId,
                    $billingDto->applicationPeriodId,
                    $billingDto->creatorId,
                    $billingDto->createdTimestamp,
                    $billingDto->modifierId,
                    $billingDto->lastModifiedTimestamp,
                    $billingDto->cost,
                    $billingDto->amountPaid,
                    $billingDto->isActive,
                    $billingDto->isDeleted,
                    $billingDto->quantity
                )
            );
        }

        $receiptEntity =
            ReceiptEntity::AllArgsConstructor(
                $billingEntities,
                $receiptDto->id,
                $receiptDto->paymentMethod,
                $receiptDto->customerId,
                $receiptDto->studentRegistrationId,
                $receiptDto->creatorId,
                $receiptDto->modifierId,
                $receiptDto->username,
                $receiptDto->fullName,
                $receiptDto->receiptNumber,
                $receiptDto->email,
                $receiptDto->notes,
                $receiptDto->publishCount,
                $receiptDto->autoPublish,
                $receiptDto->datePaid,
                $receiptDto->createdTimestamp,
                $receiptDto->isActive,
                $receiptDto->isDeleted,
                $receiptDto->chequeNumber,
                $receiptDto->lastModifiedTimestamp,
                $receiptDto->total,
                $receiptDto->personnelCode
            );
        $receiptEntity->setId($receiptDto->id);
        return $receiptEntity;
    }
}
