<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\PaymentMethodRepository;

/**
 * PaymentMethodRepository Implementation
 */
class PaymentMethodRepositoryImp implements PaymentMethodRepository
{
    private $paymentMethodStorage;


    /**
     * Class constructor
     *
     * @param [type] $paymentMethodStorage
     */
    public function __construct($paymentMethodStorage)
    {
        $this->paymentMethodStorage = $paymentMethodStorage;
    }


    /**
     * Returns collection of 'revenue in hand' payment methods
     *
     * @return PaymentMethod[]
     */
    public function getNonWaiverPaymentMethods()
    {
        return $this->paymentMethodStorage->getNonWaiverPaymentMethods();
    }


    /**
     * Returns payment method model based on $name 
     *
     * @param string $name
     * @return PaymentMethod
     */
    public function getPaymentMethodMyName($name)
    {
        return $this->paymentMethodStorage->getPaymentMethodMyName($name);
    }
}
