<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\ForPublishingReceipt;

/**
 * ForPublishingReceipt implementation
 */
class ForPublishingReceiptImp implements ForPublishingReceipt
{
    private $receiptPublisher;


    /**
     * Class constructor
     *
     * @param ReceiptEmailPublisher $receiptPublisher
     */
    public function __construct($receiptPublisher)
    {
        $this->receiptPublisher = $receiptPublisher;
    }


    /**
     * Publish receipt to client
     *
     * @param ReceiptEntity $receiptEntity
     * @return boolean
     */
    public function publishReceipt($receiptEntity)
    {
        return $this->receiptPublisher->publish($receiptEntity);
    }
}
