<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\ForGeneratingReceiptFile;

/**
 * ForGeneratingReceiptFile implementation
 */
class ForGeneratingReceiptFileImp implements ForGeneratingReceiptFile
{
    private $fileGenerator;

    /**
     * Class constructor
     *
     * @param FileGenerator $fileGenerator
     */
    public function __construct($fileGenerator)
    {
        $this->fileGenerator = $fileGenerator;
    }


    /**
     * Generate receipt file
     *
     * @param ReceiptEntity $receiptEntity
     * @return void
     */
    public function processReceipt($receiptEntity)
    {
        return $this->fileGenerator->generate($receiptEntity);
    }
}
