<?php

namespace frontend\core\services;

use frontend\core\ports\driven\BillingDto;
use frontend\core\domain\bursary\BillingEntity;


/**
 * Handles conversion between entities and DTO models for Billing
 */
class BillingConverter
{
    private function __construct()
    {
    }


    /**
     * Convert Billing DTO to Billing Entity
     *
     * @param BillingEntity $billingEntity
     * @return BillingDto
     */
    public static function toDto($billingEntity)
    {
        return new BillingDto(
            $billingEntity->getId(),
            $billingEntity->getPaymentMethod(),
            $billingEntity->getBillingCharge(),
            $billingEntity->getBillingChargeId(),
            $billingEntity->getCustomerId(),
            $billingEntity->getStudentRegistrationId(),
            $billingEntity->getAcademicOfferingId(),
            $billingEntity->getApplicationPeriodId(),
            $billingEntity->getCreatorId(),
            $billingEntity->getCreatedTimestamp(),
            $billingEntity->getModifierId(),
            $billingEntity->getLastModifiedTimestamp(),
            $billingEntity->getCost(),
            $billingEntity->getAmountPaid(),
            $billingEntity->getQuantity(),
            $billingEntity->getIsActive(),
            $billingEntity->getIsDeleted()
        );
    }


    /**
     * Convert Billing DTO to Billing entity
     *
     * @param BillingDto $billingDto
     * @return BillingEntity
     */
    public static function toEntity($billingDto)
    {
        return BillingEntity::allArgsConstructor(
            $billingDto->id,
            $billingDto->paymentMethod,
            $billingDto->billingCharge,
            $billingDto->billingChargeId,
            $billingDto->customerId,
            $billingDto->studentRegistrationId,
            $billingDto->academicOfferingId,
            $billingDto->applicationPeriodId,
            $billingDto->creatorId,
            $billingDto->createdTimestamp,
            $billingDto->modifierId,
            $billingDto->lastModifiedTimestamp,
            $billingDto->cost,
            $billingDto->amountPaid,
            $billingDto->isActive,
            $billingDto->isDeleted,
            $billingDto->quantity
        );
    }
}
