<?php

namespace frontend\core\services;

use frontend\core\domain\bursary\BillingChargeRepository;

/**
 * BillingChargeRepository Implementation
 */
class BillingChargeRepositoryImp implements BillingChargeRepository
{
    private $billingChargeStorage;


    /**
     * Class constructor
     *
     * @param BillingChargeStorage $billingChargeStorage
     */
    public function __construct($billingChargeStorage)
    {
        $this->billingChargeStorage = $billingChargeStorage;
    }


    /**
     * Returns all registry and library service fees for an application period
     * 
     * @param integer $applicationPeriodId
     * @return BillingCharge[]
     */
    public function getRegistryAndLibraryServiceBillingChargesForApplicationPeriod(
        $applicationPeriod
    ) {
        return $this->billingChargeStorage->getRegistryAndLibraryServiceBillingChargesForApplicationPeriod(
            $applicationPeriod
        );
    }


    /**
     * Returns the name of the type a billing charge is associated with
     * 
     * @param BillingCharge $billingCharge
     * @return string
     */
    public function getBillingChargeFeeName($billingCharge)
    {
        return $this->billingChargeStorage->getBillingChargeFeeName($billingCharge);
    }


    /**
     * Returns the name of the type a billing charge is associated with
     *
     * @param integer $billingChargeId
     * @return string
     */
    public function getBillingChargeFeeNameById($billingChargeId)
    {
        return $this->billingChargeStorage->getBillingChargeFeeNameById($billingChargeId);
    }
}
