<?php

namespace frontend\core\services;

use frontend\adapters\driven\real\persistence\ApplicationPeriod;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\domain\bursary\ApplicationPeriodRepository;

/**
 * ApplicationPeriodRepository Implementation
 */
class ApplicationPeriodRepositoryImp implements ApplicationPeriodRepository
{
    private $applicationPeriodStorage;

    /**
     * Class constructor
     *
     * @param ApplicationPeriodStorage $applicationPeriodStorage
     */
    public function __construct($applicationPeriodStorage)
    {
        $this->applicationPeriodStorage = $applicationPeriodStorage;
    }


    /**
     * Undocumented function
     *
     * @param StudentRegistration $registration
     * @return ApplicationPeriod
     */
    public function getApplicationPeriodFromRegistration($registration)
    {
        return $this->applicationPeriodStorage->getApplicationPeriodFromRegistration(
            $registration
        );
    }
}
