<?php

namespace frontend\core\ports\driver\registryandlibraryservices;

/**
 * DTO for registry and library fee form generation response
 */
class ViewRegistryAndLibraryFeesResponse
{
    public $status;
    public $model;

    private function __construct()
    {
    }

    /**
     * Generates response model indicating the successful execution of request
     *
     * @param ServiceFeeCatalog $model
     * @return ViewRegistryAndLibraryFeesResponse
     */
    public static function createSuccessResponse($model)
    {
        $response = new ViewRegistryAndLibraryFeesResponse();
        $response->status = true;
        $response->model = $model;
        return $response;
    }

    /**
     *Builds and returns feedback indicating a failed operation
     *
     * @return ViewRegistryAndLibraryFeesResponse
     */
    public static function createFailureResponse()
    {
        $response = new ViewRegistryAndLibraryFeesResponse();
        $response->status = false;
        $response->model = null;
        return $response;
    }
}
