<?php

namespace frontend\core\ports\driver\registryandlibraryservices;

/**
 * DTO for registry and library fee receipt publishing response
 */
class PublishReceiptResponse
{
    public $status;
    public $receiptId;
    public $customerUsername;

    private function __construct()
    {
    }


    /**
     * Builds and returns successful feedback response to publihing payment
     *
     * @param integer $receiptId
     * @param string $customerUsername
     * @return PublishReceiptResponse
     */
    public static function createSuccessResponse($receiptId, $customerUsername)
    {
        $response = new PublishReceiptResponse();
        $response->status = true;
        $response->receiptId = $receiptId;
        $response->customerUsername = $customerUsername;
        return $response;
    }


    /**
     * Builds and returns feedback indicating a failed operation
     *
     * @return PublishReceiptResponse
     */
    public static function createFailureResponse()
    {
        $response = new PublishReceiptResponse();
        $response->status = false;
        $response->receiptId = null;
        $response->customerUsername = null;
        return $response;
    }
}
