<?php

namespace frontend\core\ports\driver\registryandlibraryservices;

/**
 * DTO for registry and library fee payment preview response
 */
class PreviewPaymentResponse
{
    public $status;
    public $model;

    private function __construct()
    {
    }


    /**
     * Builds and returns successful feedback response to previewing payment
     *
     * @param RegistryAndLibraryFeesViewModel $model
     * @return PreviewPaymentResponse
     */
    public static function createSuccessResponse($model)
    {
        $response = new PreviewPaymentResponse();
        $response->status = true;
        $response->model = $model;
        return $response;
    }


    /**
     * Builds and returns feedback indicating a failed operation to preview receipt
     *
     * @return PreviewPaymentResponse
     */
    public static function createFailureResponse()
    {
        $response = new PreviewPaymentResponse();
        $response->status = false;
        $response->model = null;
        return $response;
    }
}
