<?php

namespace frontend\core\ports\driver\registryandlibraryservices;

/**
 * DTO for registry and library fee payment confirmation response
 */
class ConfirmPaymentResponse
{
    public $status;
    public $receiptId;
    public $customerUsername;

    private function __construct()
    {
    }


    /**
     * Builds and returns successful feedback response to processing payment
     *
     * @param integer $receiptId
     * @param string $customerUsername
     * @return ConfirmPaymentResponse
     */
    public static function createSuccessResponse($receiptId, $customerUsername)
    {
        $response = new ConfirmPaymentResponse();
        $response->status = true;
        $response->receiptId = $receiptId;
        $response->customerUsername = $customerUsername;
        return $response;
    }


    /**
     * Builds and returns feedback indicating a failed operation
     *
     * @return ConfirmPaymentResponse
     */
    public static function createFailureResponse()
    {
        $response = new ConfirmPaymentResponse();
        $response->status = false;
        $response->receiptId = null;
        $response->customerUsername = null;
        return $response;
    }
}
