<?php

namespace frontend\core\ports\driven;

/*
 * Driven port for querying receipt and billing db models and building their 
 * corresponding DTOs
 */

interface ReceiptStorage
{
    /**
     * Persists receipts and associated billings.
     *
     * @param ReceiptDto $receiptDto
     * @param BillingDto[] $billingDtos
     * @return Receipt
     */
    public function addReceiptAndBillings($receiptDto, $billingDtos);


    /**
     * Finds and return receipt model
     *
     * @param integer $id
     * @return ReceiptDto
     */
    public function findReceiptById($id);


    /**
     * Returns billing models associated with receipt
     *
     * @param integer $receiptId
     * @return BillingDto[]
     */
    public function findReceiptBillings($receiptId);
}
