<?php

namespace frontend\core\ports\driven;

/*
 * Driven port for querying payment methods
 */

interface PaymentMethodStorage
{
    /**
     * Returns collection of 'revenue in hand' payment methods
     *
     * @return PaymentMethod[]
     */
    public function getNonWaiverPaymentMethods();


    /**
     * Returns payment method model based on $name 
     *
     * @param string $name
     * @return PaymentMethod
     */
    public function getPaymentMethodMyName($name);


    /**
     * Returns payment method model based on $id
     *
     * @param integer $id
     * @return PaymentMethod
     */
    public function getPaymentMethodById($id);
}
