<?php

namespace frontend\core\ports\driven;

/*
 * Driven port for querying billing charges
 */

interface BillingChargeStorage
{
    /**
     * Returns all registry and library service fees for an application period
     * 
     * @param integer $applicationPeriodId
     * @return BillingCharge[]
     */
    public function getRegistryAndLibraryServiceBillingChargesForApplicationPeriod(
        $applicationPeriod
    );


    /**
     * Returns the name of the type a billing charge is associated with
     * 
     * @param BillingCharge $billingCharge
     * @return string
     */
    public function getBillingChargeFeeName($billingCharge);


    /**
     * Returns billing charge by $id
     *
     * @param integer $id
     * @return BillingCharge
     */
    public function getBillingChargeById($id);


    /**
     * Returns the name of the type a billing charge is associated with
     *
     * @param integer $billingChargeId
     * @return string
     */
    public function getBillingChargeFeeNameById($billingChargeId);
}
