<?php

namespace frontend\core\domain\exceptions;

class ApplicationException extends \RuntimeException
{
    /**
     * @var integer HTTP status code, such as 403, 404, 500, etc.
     */
    public $statusCode;
    public $message;


    public function __construct($status, $message)
    {
        $this->statusCode = $status;
        $this->message = $message;
    }


    /**
     * @return string the user-friendly name of this exception
     */
    public function getName()
    {
        return "Application Exception";
    }
}
