<?php

namespace frontend\core\domain\bursary;

/**
 * Driver port for receipt model queries
 */
interface ReceiptRepository
{
    /**
     * Retrieves receipt and associated billings and builds Receipt Aggregate
     * 
     * @param int $id
     * @return ReceiptEntity
     */
    public function find($id);


    /**
     * Persist Receipt aggregates to storage
     * 
     * @param ReceiptEntity $receipt
     * @return Receipt
     */
    public function add($receiptEntity);


    /**
     * Modify ReceiptEntity and persist changes
     * 
     * @param ReceiptEntity $receipt
     * @return Receipt
     */
    public function update($receiptEntity);


    /**
     *
     * @param ReceiptEntity $receiptEntity
     * @return BillingEntity[]
     */
    public function getBillings($receiptEntity);
}
