<?php

namespace frontend\core\domain\bursary;

/**
 * Receipt aggregate
 */
class ReceiptEntity
{
    private $billings;
    private $id;
    private $paymentMethod;
    private $customerId;
    private $studentRegistrationId;
    private $creatorId;
    private $modifierId;
    private $username;
    private $fullName;
    private $receiptNumber;
    private $email;
    private $notes;
    private $publishCount;
    private $autoPublish;
    private $datePaid;
    private $createdTimestamp;
    private $isActive;
    private $isDeleted;
    private $chequeNumber;
    private $lastModifiedTimestamp;
    private $total;
    private $personnelCode;

    private function __construct()
    {
    }


    /**
     * Class constructor for object initialization
     *
     * @param string $paymentMethod
     * @param integer $customerId
     * @param integer $studentRegistrationId
     * @param integer $creatorId
     * @param integer $modifierId
     * @param string $username
     * @param string $fullName
     * @param string $receiptNumber
     * @param string $email
     * @param string $notes
     * @param integer $publishCount
     * @param integer $autoPublish
     * @param string $datePaid
     * @param string $createdTimestamp
     * @param string $chequeNumber
     * @param string $lastModifiedTimestamp
     * @param float $total
     * @param string $personnelCode
     * @return ReceiptEntity
     */
    public static function defaultConstructor(
        $paymentMethod,
        $customerId,
        $studentRegistrationId,
        $creatorId,
        $modifierId,
        $username,
        $fullName,
        $receiptNumber,
        $email,
        $notes,
        $publishCount,
        $autoPublish,
        $datePaid,
        $createdTimestamp,
        $chequeNumber,
        $lastModifiedTimestamp,
        $total,
        $personnelCode
    ) {
        $model = new ReceiptEntity();
        $model->billings = array();
        $model->id = null;
        $model->paymentMethod = $paymentMethod;
        $model->customerId = $customerId;
        $model->studentRegistrationId = $studentRegistrationId;
        $model->creatorId = $creatorId;
        $model->modifierId = $modifierId;
        $model->username = $username;
        $model->fullName = $fullName;
        $model->receiptNumber = $receiptNumber;
        $model->email = $email;
        $model->notes = $notes;
        $model->publishCount = $publishCount;
        $model->autoPublish = $autoPublish;
        $model->datePaid = $datePaid;
        $model->createdTimestamp = $createdTimestamp;
        $model->isActive = 1;
        $model->isDeleted = 0;
        $model->chequeNumber = $chequeNumber;
        $model->lastModifiedTimestamp = $lastModifiedTimestamp;

        return $model;
    }


    /**
     * Class constructor for objects that are retrieved from memory.
     *
     * @param BillingEntity[] $billings
     * @param integer $id
     * @param string $paymentMethod
     * @param integer $customerId
     * @param integer $studentRegistrationId
     * @param integer $creatorId
     * @param integer $modifierId
     * @param string $username
     * @param string $fullName
     * @param string $receiptNumber
     * @param string $email
     * @param string $notes
     * @param integer $publishCount
     * @param integer $autoPublish
     * @param string $datePaid
     * @param string $createdTimestamp
     * @param integer $isActive
     * @param integer $isDeleted
     * @param string $chequeNumber
     * @param string $lastModifiedTimestamp
     * @param float $total
     * @param string $personnelCode
     * @return ReceiptEntity
     */
    public static function AllArgsConstructor(
        $billings,
        $id,
        $paymentMethod,
        $customerId,
        $studentRegistrationId,
        $creatorId,
        $modifierId,
        $username,
        $fullName,
        $receiptNumber,
        $email,
        $notes,
        $publishCount,
        $autoPublish,
        $datePaid,
        $createdTimestamp,
        $isActive,
        $isDeleted,
        $chequeNumber,
        $lastModifiedTimestamp,
        $total,
        $personnelCode
    ) {
        $model = new ReceiptEntity();
        $model->billings = $billings;
        $model->id = $id;
        $model->paymentMethod = $paymentMethod;
        $model->customerId = $customerId;
        $model->studentRegistrationId = $studentRegistrationId;
        $model->creatorId = $creatorId;
        $model->modifierId = $modifierId;
        $model->username = $username;
        $model->fullName = $fullName;
        $model->receiptNumber = $receiptNumber;
        $model->email = $email;
        $model->notes = $notes;
        $model->publishCount = $publishCount;
        $model->autoPublish = $autoPublish;
        $model->datePaid = $datePaid;
        $model->createdTimestamp = $createdTimestamp;
        $model->isActive = $isActive;
        $model->isDeleted = $isDeleted;
        $model->chequeNumber = $chequeNumber;
        $model->lastModifiedTimestamp = $lastModifiedTimestamp;
        $model->total = $total;
        $model->personnelCode = $personnelCode;
        return $model;
    }

    /**
     * Set $id field
     *
     * @param integer $id
     * @return ReceiptEntity
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }


    /**
     * Add billing record
     *
     * @param BillingEntity $billing
     * @return void
     */
    public function addBilling($billing)
    {
        array_push($this->billings, $billing);
    }


    /**
     * $billings setter method
     *
     * @param [type] $billings
     * @return void
     */
    public function setBillings($billings)
    {
        $this->billings = $billings;
    }


    /**
     * billings getter method
     *
     * @return void
     */
    public function getBillings()
    {
        return $this->billings;
    }


    /**
     * id getter method
     *
     * @return void
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * paymentMethod getter method
     *
     * @return void
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }


    /**
     * customerId getter method
     *
     * @return void
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }


    /**
     * studentRegistrationId getter method
     *
     * @return void
     */
    public function getStudentRegistrationId()
    {
        return $this->studentRegistrationId;
    }


    /**
     * creatorId getter method
     */
    public function getCreatorId()
    {
        return $this->creatorId;
    }


    /**
     * modifierId etter method
     *
     * @return void
     */
    public function getModifierId()
    {
        return $this->modifierId;
    }


    /**
     * username getter method
     *
     * @return void
     */
    public function getUsername()
    {
        return $this->username;
    }


    /**
     * fullName getter method
     *
     * @return void
     */
    public function getFullName()
    {
        return $this->fullName;
    }


    /**
     * receiptNumber getter method
     *
     * @return void
     */
    public function getReceiptNumber()
    {
        return $this->receiptNumber;
    }


    /**
     * email getter method
     *
     * @return void
     */
    public function getEmail()
    {
        return $this->email;
    }


    /**
     * notes getter method
     *
     * @return void
     */
    public function getNotes()
    {
        return $this->notes;
    }


    /**
     * publishCount getter method
     *
     * @return void
     */
    public function getPublishCount()
    {
        return $this->publishCount;
    }


    /**
     * autoPublish getter method
     *
     * @return void
     */
    public function getAutoPublish()
    {
        return $this->autoPublish;
    }


    /**
     * datePaid getter method
     *
     * @return void
     */
    public function getDatePaid()
    {
        return $this->datePaid;
    }


    /**
     * createdTimestamp getter method
     *
     * @return void
     */
    public function getCreatedTimestamp()
    {
        return $this->createdTimestamp;
    }


    /**
     * isActive getter method
     *
     * @return void
     */
    public function getIsActive()
    {
        return $this->isActive;
    }


    /**
     * isDeleted getter method
     *
     * @return void
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }


    /**
     * chequeNumber getter method
     *
     * @return void
     */
    public function getChequeNumber()
    {
        return $this->chequeNumber;
    }


    /**
     * lastModifiedTimestamp getter method
     *
     * @return void
     */
    public function getLastModifiedTimestamp()
    {
        return $this->lastModifiedTimestamp;
    }


    /**
     * Build filepath for receipt file
     *
     * @param [type] $targetDirectory
     * @return void
     */
    public function determineFilePath($targetDirectory)
    {
        $filename = "{$this->receiptNumber}.pdf";
        return "{$targetDirectory}/{$filename}";
    }


    /**
     * total getter method
     *
     * @return void
     */
    public function getTotal()
    {
        return $this->total;
    }


    /**
     * personnelCodegetter method
     *
     * @return void
     */
    public function getPersonnelCode()
    {
        return $this->personnelCode;
    }
}
