<?php

namespace frontend\core\domain\bursary;

/**
 * Billing entity domain model
 */
class BillingEntity
{
    private $id;
    private $paymentMethod;
    private $billingCharge;
    private $billingChargeId;
    private $customerId;
    private $studentRegistrationId;
    private $academicOfferingId;
    private $applicationPeriodId;
    private $creatorId;
    private $createdTimestamp;
    private $modifierId;
    private $lastModifiedTimestamp;
    private $cost;
    private $amountPaid;
    private $quantity;
    private $isActive;
    private $isDeleted;

    private function __construct()
    {
    }


    /**
     * Class constructor for object initialization
     *
     * @param string $paymentMethod
     * @param string $billingCharge
     * @param integer $billingChargeId
     * @param integer $customerId
     * @param integer $studentRegistrationId
     * @param integer $academicOfferingId
     * @param integer $applicationPeriodId
     * @param integer $creatorId
     * @param string $createdTimestamp
     * @param integer $modifierId
     * @param string $lastModifiedTimestamp
     * @param float $cost
     * @param float $amountPaid
     * @param integer $quantity
     * @return BillingEntity
     */
    public static function defaultConstructor(
        $paymentMethod,
        $billingCharge,
        $billingChargeId,
        $customerId,
        $studentRegistrationId,
        $academicOfferingId,
        $applicationPeriodId,
        $creatorId,
        $createdTimestamp,
        $modifierId,
        $lastModifiedTimestamp,
        $cost,
        $amountPaid,
        $quantity
    ) {
        $model = new BillingEntity();
        $model->id = null;
        $model->paymentMethod = $paymentMethod;
        $model->billingCharge = $billingCharge;
        $model->billingChargeId = $billingChargeId;
        $model->customerId = $customerId;
        $model->studentRegistrationId = $studentRegistrationId;
        $model->academicOfferingId = $academicOfferingId;
        $model->applicationPeriodId = $applicationPeriodId;
        $model->creatorId = $creatorId;
        $model->createdTimestamp = $createdTimestamp;
        $model->modifierId = $modifierId;
        $model->lastModifiedTimestamp = $lastModifiedTimestamp;
        $model->cost = $cost;
        $model->amountPaid = $amountPaid;
        $model->quantity = $quantity;
        $model->isActive = 1;
        $model->isDeleted = 0;
        return $model;
    }


    /**
     * Class constructor for objects that are retrieved from memory.
     *
     * @param integer $id
     * @param string $paymentMethod
     * @param string $billingCharge
     * @param integer $billingChargeId
     * @param integer $customerId
     * @param integer $studentRegistrationId
     * @param integer $academicOfferingId
     * @param integer $applicationPeriodId
     * @param integer $creatorId
     * @param string $createdTimestamp
     * @param integer $modifierId
     * @param string $lastModifiedTimestamp
     * @param float $cost
     * @param integer $isActive
     * @param integer $isDeleted
     * @param integer $quantity
     * @return void
     */
    public static function allArgsConstructor(
        $id,
        $paymentMethod,
        $billingCharge,
        $billingChargeId,
        $customerId,
        $studentRegistrationId,
        $academicOfferingId,
        $applicationPeriodId,
        $creatorId,
        $createdTimestamp,
        $modifierId,
        $lastModifiedTimestamp,
        $cost,
        $amountPaid,
        $isActive,
        $isDeleted,
        $quantity
    ) {
        $model = new BillingEntity();
        $model->id = $id;
        $model->paymentMethod = $paymentMethod;
        $model->billingCharge = $billingCharge;
        $model->billingChargeId = $billingChargeId;
        $model->customerId = $customerId;
        $model->studentRegistrationId = $studentRegistrationId;
        $model->academicOfferingId = $academicOfferingId;
        $model->applicationPeriodId = $applicationPeriodId;
        $model->creatorId = $creatorId;
        $model->createdTimestamp = $createdTimestamp;
        $model->modifierId = $modifierId;
        $model->lastModifiedTimestamp = $lastModifiedTimestamp;
        $model->cost = $cost;
        $model->amountPaid = $amountPaid;
        $model->quantity = $quantity;
        $model->isActive = $isActive;
        $model->isDeleted = $isDeleted;
        $model->quantity = $quantity;
        return $model;
    }


    /**
     * Setter method
     *
     * @param integer $id
     * @return integer
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }


    /**
     * id getter method
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * paymentMethod getter method
     *
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }


    /**
     * billingCharge getter method
     *
     * @return string
     */
    public function getBillingCharge()
    {
        return $this->billingCharge;
    }


    /**
     * billingChargeId getter method
     *
     * @return integer
     */
    public function getBillingChargeId()
    {
        return $this->billingChargeId;
    }


    /**
     * customerId getter method
     *
     * @return integer
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }


    /**
     * studentRegistrationId getter method
     *
     * @return integer
     */
    public function getStudentRegistrationId()
    {
        return $this->studentRegistrationId;
    }


    /**
     * academicOfferingId getter method
     *
     * @return integer
     */
    public function getAcademicOfferingId()
    {
        return $this->academicOfferingId;
    }


    /**
     * applicationPeriodId getter method
     *
     * @return integer
     */
    public function getApplicationPeriodId()
    {
        return $this->applicationPeriodId;
    }


    /**
     * creatorId getter method
     *
     * @return integer
     */
    public function getCreatorId()
    {
        return $this->creatorId;
    }


    /**
     * createdTimestamp getter method
     *
     * @return string
     */
    public function getCreatedTimestamp()
    {
        return $this->createdTimestamp;
    }


    /**
     * modifierId getter method
     *
     * @return integer
     */
    public function getModifierId()
    {
        return $this->modifierId;
    }


    /**
     * lastModifiedTimestamp getter method
     *
     * @return string
     */
    public function getLastModifiedTimestamp()
    {
        return $this->lastModifiedTimestamp;
    }


    /**
     * cost getter method
     *
     * @return float
     */
    public function getCost()
    {
        return $this->cost;
    }


    /**
     * amountPaid getter method
     *
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->amountPaid;
    }


    /**
     * quantity getter method
     *
     * @return integer
     */
    public function getQuantity()
    {
        return $this->quantity;
    }


    /**
     * isActive getter method
     *
     * @return integer
     */
    public function getIsActive()
    {
        return $this->isActive;
    }


    /**
     * isDeleted getter method
     *
     * @return integer
     */
    public function getIsDeleted()
    {
        return $this->isDeleted;
    }
}
