<?php

namespace frontend\core\domain\bursary;

/**
 * Driver port for billing charge model queries
 */
interface BillingChargeRepository
{
    /**
     * Returns all registry and library service fees for an application period
     * 
     * @param integer $applicationPeriodId
     * @return BillingCharge[]
     */
    public function getRegistryAndLibraryServiceBillingChargesForApplicationPeriod(
        $applicationPeriodId
    );


    /**
     * Returns the name of the type a billing charge is associated with
     * 
     * @param BillingCharge $billingCharge
     * @return string
     */
    public function getBillingChargeFeeName($billingCharge);


    /**
     * Returns the name of the type a billing charge is associated with
     *
     * @param integer $billingChargeId
     * @return string
     */
    public function getBillingChargeFeeNameById($billingChargeId);
}
