<?php

namespace frontend\adapters\driven\real\persistence;

use Yii;

/**
 * This is the model class for table "payment_method".
 *
 * @property string $paymentmethodid
 * @property string $name
 * @property string $createdby
 * @property string $lastmodifiedby
 * @property integer $isactive
 * @property integer $isdeleted
 *
 * @property Billing[] $billings
 * @property Person $createdby0
 * @property Person $lastmodifiedby0
 * @property Receipt[] $receipts
 * @property Transaction[] $transactions
 */
class PaymentMethod extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'payment_method';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['createdby', 'lastmodifiedby', 'isactive', 'isdeleted'], 'integer'],
            [['name'], 'string', 'max' => 45]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'paymentmethodid' => 'Paymentmethodid',
            'name' => 'Name',
            'createdby' => 'Createdby',
            'lastmodifiedby' => 'Lastmodifiedby',
            'isactive' => 'Isactive',
            'isdeleted' => 'Isdeleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillings()
    {
        return $this->hasMany(Billing::class, ['payment_method_id' => 'paymentmethodid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreatedby0()
    {
        return $this->hasOne(Person::class, ['personid' => 'createdby']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastmodifiedby0()
    {
        return $this->hasOne(Person::class, ['personid' => 'lastmodifiedby']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReceipts()
    {
        return $this->hasMany(Receipt::class, ['payment_method_id' => 'paymentmethodid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTransactions()
    {
        return $this->hasMany(Transaction::class, ['paymentmethodid' => 'paymentmethodid']);
    }
}
