<?php

namespace frontend\adapters\driven\real\persistence;

use Yii;

/**
 * This is the model class for table "billing_type".
 *
 * @property string $id
 * @property string $billing_category_id
 * @property string $division_id
 * @property string $name
 * @property string $description
 * @property string $creator_id
 * @property string $modifier_id
 * @property string $created_at
 * @property string $modified_at
 * @property integer $is_deleted
 *
 * @property BillingCharge[] $billingCharges
 * @property BillingCategory $billingCategory
 * @property Division $division
 * @property Person $creator
 * @property Person $modifier
 */
class BillingType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'billing_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['billing_category_id', 'division_id', 'name'], 'required'],
            [['billing_category_id', 'division_id', 'creator_id', 'modifier_id', 'is_deleted'], 'integer'],
            [['description'], 'string'],
            [['created_at', 'modified_at'], 'safe'],
            [['name'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billing_category_id' => 'Billing Category ID',
            'division_id' => 'Division ID',
            'name' => 'Name',
            'description' => 'Description',
            'creator_id' => 'Creator ID',
            'modifier_id' => 'Modifier ID',
            'created_at' => 'Created At',
            'modified_at' => 'Modified At',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCharges()
    {
        return $this->hasMany(BillingCharge::class, ['billing_type_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCategory()
    {
        return $this->hasOne(BillingCategory::class, ['id' => 'billing_category_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDivision()
    {
        return $this->hasOne(Division::class, ['divisionid' => 'division_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreator()
    {
        return $this->hasOne(Person::class, ['personid' => 'creator_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getModifier()
    {
        return $this->hasOne(Person::class, ['personid' => 'modifier_id']);
    }
}
