<?php

namespace frontend\adapters\driven\real\persistence;

use Yii;

/**
 * This is the model class for table "billing_charge".
 *
 * @property string $id
 * @property string $billing_type_id
 * @property string $application_period_id
 * @property string $academic_offering_id
 * @property string $modifier_id
 * @property string $cost
 * @property integer $payable_on_enrollment
 * @property integer $is_active
 * @property integer $is_deleted
 * @property string $creator_id
 * @property string $created_at
 * @property string $modified_at
 *
 * @property Billing[] $billings
 * @property AcademicOffering $academicOffering
 * @property ApplicationPeriod $applicationPeriod
 * @property BillingType $billingType
 * @property Person $modifier
 * @property Person $creator
 */
class BillingCharge extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'billing_charge';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['billing_type_id', 'application_period_id', 'modifier_id', 'cost'], 'required'],
            [['billing_type_id', 'application_period_id', 'academic_offering_id', 'modifier_id', 'payable_on_enrollment', 'is_active', 'is_deleted', 'creator_id'], 'integer'],
            [['cost'], 'number'],
            [['created_at', 'modified_at'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billing_type_id' => 'Billing Type ID',
            'application_period_id' => 'Application Period ID',
            'academic_offering_id' => 'Academic Offering ID',
            'modifier_id' => 'Modifier ID',
            'cost' => 'Cost',
            'payable_on_enrollment' => 'Payable On Enrollment',
            'is_active' => 'Is Active',
            'is_deleted' => 'Is Deleted',
            'creator_id' => 'Creator ID',
            'created_at' => 'Created At',
            'modified_at' => 'Modified At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillings()
    {
        return $this->hasMany(Billing::class, ['billing_charge_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicOffering()
    {
        return $this->hasOne(AcademicOffering::class, ['academicofferingid' => 'academic_offering_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApplicationPeriod()
    {
        return $this->hasOne(ApplicationPeriod::class, ['applicationperiodid' => 'application_period_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingType()
    {
        return $this->hasOne(BillingType::class, ['id' => 'billing_type_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getModifier()
    {
        return $this->hasOne(Person::class, ['personid' => 'modifier_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreator()
    {
        return $this->hasOne(Person::class, ['personid' => 'creator_id']);
    }
}
