<?php

namespace frontend\adapters\driven\real\persistence;

use Yii;

/**
 * This is the model class for table "application_period".
 *
 * @property string $applicationperiodid
 * @property string $applicationperiodstatusid
 * @property string $divisionid
 * @property string $personid
 * @property string $academicyearid
 * @property string $name
 * @property string $onsitestartdate
 * @property string $onsiteenddate
 * @property string $offsitestartdate
 * @property string $offsiteenddate
 * @property integer $isactive
 * @property integer $isdeleted
 * @property string $applicationperiodtypeid
 * @property integer $iscomplete
 * @property integer $catalog_approved
 * @property integer $programmes_added
 * @property integer $cape_subjects_added
 * @property integer $min_certificates_to_matriculate
 * @property string $modifier_id
 * @property string $cereated_at
 * @property string $modified_at
 *
 * @property AcademicOffering[] $academicOfferings
 * @property Division $division
 * @property Person $person
 * @property AcademicYear $academicyear
 * @property ApplicationPeriodType $applicationperiodtype
 * @property ApplicationperiodStatus $applicationperiodstatus
 * @property Person $modifier
 * @property Billing[] $billings
 * @property BillingCharge[] $billingCharges
 * @property Package[] $packages
 */
class ApplicationPeriod extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'application_period';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['applicationperiodstatusid', 'divisionid', 'personid', 'academicyearid', 'name', 'onsitestartdate', 'offsitestartdate', 'applicationperiodtypeid'], 'required'],
            [['applicationperiodstatusid', 'divisionid', 'personid', 'academicyearid', 'isactive', 'isdeleted', 'applicationperiodtypeid', 'iscomplete', 'catalog_approved', 'programmes_added', 'cape_subjects_added', 'min_certificates_to_matriculate', 'modifier_id'], 'integer'],
            [['onsitestartdate', 'onsiteenddate', 'offsitestartdate', 'offsiteenddate', 'cereated_at', 'modified_at'], 'safe'],
            [['name'], 'string', 'max' => 45]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'applicationperiodid' => 'Applicationperiodid',
            'applicationperiodstatusid' => 'Applicationperiodstatusid',
            'divisionid' => 'Divisionid',
            'personid' => 'Personid',
            'academicyearid' => 'Academicyearid',
            'name' => 'Name',
            'onsitestartdate' => 'Onsitestartdate',
            'onsiteenddate' => 'Onsiteenddate',
            'offsitestartdate' => 'Offsitestartdate',
            'offsiteenddate' => 'Offsiteenddate',
            'isactive' => 'Isactive',
            'isdeleted' => 'Isdeleted',
            'applicationperiodtypeid' => 'Applicationperiodtypeid',
            'iscomplete' => 'Iscomplete',
            'catalog_approved' => 'Catalog Approved',
            'programmes_added' => 'Programmes Added',
            'cape_subjects_added' => 'Cape Subjects Added',
            'min_certificates_to_matriculate' => 'Min Certificates To Matriculate',
            'modifier_id' => 'Modifier ID',
            'cereated_at' => 'Cereated At',
            'modified_at' => 'Modified At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicOfferings()
    {
        return $this->hasMany(AcademicOffering::class, ['applicationperiodid' => 'applicationperiodid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDivision()
    {
        return $this->hasOne(Division::class, ['divisionid' => 'divisionid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPerson()
    {
        return $this->hasOne(Person::class, ['personid' => 'personid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicyear()
    {
        return $this->hasOne(AcademicYear::class, ['academicyearid' => 'academicyearid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApplicationperiodtype()
    {
        return $this->hasOne(ApplicationPeriodType::class, ['applicationperiodtypeid' => 'applicationperiodtypeid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getApplicationperiodstatus()
    {
        return $this->hasOne(ApplicationperiodStatus::class, ['applicationperiodstatusid' => 'applicationperiodstatusid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getModifier()
    {
        return $this->hasOne(Person::class, ['personid' => 'modifier_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillings()
    {
        return $this->hasMany(Billing::class, ['application_period_id' => 'applicationperiodid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCharges()
    {
        return $this->hasMany(BillingCharge::class, ['application_period_id' => 'applicationperiodid']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPackages()
    {
        return $this->hasMany(Package::class, ['applicationperiodid' => 'applicationperiodid']);
    }
}
