<?php

namespace frontend\adapters\driven\real;

use frontend\core\ports\driven\ReceiptEmailPublisher;
use Yii;

/**
 * Driven adapter for email publishing feature
 */
class SwiftMailerReceiptEmailPublisher implements ReceiptEmailPublisher
{
    private $receiptFileDirectory;


    /**
     * Class constructor
     *
     * @param [type] $receiptFileDirectory
     */
    public function __construct($receiptFileDirectory)
    {
        $this->receiptFileDirectory = $receiptFileDirectory;
    }


    /**
     * Publishes email with receipt attached
     *
     * @param ReceiptEntity $receiptEntity
     * @return boolean whether this message is sent successfully.
     */
    public function publish($receiptEntity)
    {
        return Yii::$app->mailer
            ->compose(
                "bursary/receipt.php",
                ["userFullName" => $receiptEntity->getFullName()]
            )
            ->setFrom(Yii::$app->params['bursaryEmail'])
            ->setTo($receiptEntity->getEmail())
            ->setSubject(
                "St. Vincent and the Grenadines Community College Payment"
            )
            ->attach($this->getFilePath($receiptEntity))
            ->send();
    }


    /**
     * Generates filepath for receipt
     *
     * @param ReceiptEntity $receiptEntity
     * @return string|boolean
     */
    private function getFilePath($receiptEntity)
    {
        $receiptNumber = $receiptEntity->getReceiptNumber();

        $filePath = "{$this->receiptFileDirectory}{$receiptNumber}.pdf";

        if (file_exists($filePath) == true) {
            return $filePath;
        } else {
            return false;
        }
    }
}
