<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\User;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\UserStorage;

/**
 * Driven adapter for managing user models
 */
class ActiveRecordUserStorage implements UserStorage
{
    /**
     * Return user model based on $id
     *
     * @param integer $id
     * @return StudentRegistration
     * @throws ModelNotFoundException
     */
    public function getUserById($id)
    {
        $model =
            User::find()
            ->where(["personid" => $id])
            ->one();
        if ($model === null) {
            throw new ModelNotFoundException("User not found.");
        } else {
            return $model;
        }
    }
}
