<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\Student;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\StudentStorage;

/**
 * Driven adapter for managing student models
 */
class ActiveRecordStudentStorage implements StudentStorage
{
    /**
     * Returns Student model based on $personid
     *
     * @param integer $id
     * @return StudentRegistration
     * @throws ModelNotFoundException
     */
    public function getStudentByPersonId($id)
    {
        $model =
            Student::find()
            ->where(["personid" => $id])
            ->one();
        if ($model === null) {
            throw new ModelNotFoundException("Student not found.");
        } else {
            return $model;
        }
    }
}
