<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\StudentRegistration;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\StudentRegistrationStorage;

/**
 * Driven adapter for managing student registration models
 */
class ActiveRecordStudentRegistrationStorage implements StudentRegistrationStorage
{

    /**
     * Return Student Registration model based on $id
     *
     * @param integer $id
     * @return StudentRegistration
     */
    public function getStudentRegistrationById($id)
    {
        $model =
            StudentRegistration::find()
            ->where(["studentregistrationid" => $id])
            ->one();
        if ($model === null) {
            throw new ModelNotFoundException("Student registration not found");
        } else {
            return $model;
        }
    }
}
