<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\PaymentMethod;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\PaymentMethodStorage;


/**
 * Driven adapter for managing payment method models
 */
class ActiveRecordPaymentMethodStorage implements PaymentMethodStorage
{
    /**
     * Returns collection of 'revenue in hand' payment methods
     *
     * @return PaymentMethod[]
     * @throws ModelNotFoundException
     */
    public function getNonWaiverPaymentMethods()
    {
        $resultSet =
            PaymentMethod::find()
            ->where(["isdeleted" => 0])
            ->andWhere(["not", ["name" => ["Vaccination Waiver", "Combined"]]])
            ->all();
        if ($resultSet == false) {
            throw new ModelNotFoundException("Payment methods not found.");
        } else {
            return $resultSet;
        }
    }


    /**
     * Returns payment method model based on $name 
     *
     * @param string $name
     * @return PaymentMethod
     * @throws ModelNotFoundException
     */
    public function getPaymentMethodMyName($name)
    {
        $model =
            PaymentMethod::find()->where(["name" => $name])->one();

        if ($model === null) {
            throw new ModelNotFoundException("Payment method not found.");
        } else {
            return $model;
        }
    }


    /**
     * Returns payment method model based on $id
     *
     * @param integer $id
     * @return PaymentMethod
     * @throws ModelNotFoundException
     */
    public function getPaymentMethodById($id)
    {
        $model =
            PaymentMethod::find()->where(["paymentmethodid" => $id])->one();

        if ($model === null) {
            throw new ModelNotFoundException("Payment method not found.");
        } else {
            return $model;
        }
    }
}
