<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\Employee;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\EmployeeStorage;

/**
 * Driven adapter for managing employee models
 */
class ActiveRecordEmployeeStorage implements EmployeeStorage
{
    /**
     * Returns employee model by $id
     *
     * @param integer $id
     * @return Employee
     * @throws ModelNotFoundException
     */
    public function getEmployeeByPersonId($id)
    {
        $model =
            Employee::find()
            ->where(["personid" => $id])
            ->one();
        if ($model === null) {
            throw new ModelNotFoundException("Employee not found.");
        } else {
            return $model;
        }
    }
}
