<?php

namespace frontend\adapters\driven\real;

use frontend\adapters\driven\real\persistence\ApplicationPeriod;
use frontend\core\domain\exceptions\ModelNotFoundException;
use frontend\core\ports\driven\ApplicationPeriodStorage;

/**
 * Driven adapter for managing application period models
 */
class ActiveRecordApplicationPeriodStorage implements ApplicationPeriodStorage
{
    /**
     * Returns the application period of a student's registration
     *
     * @param StudentRegistration $registration
     * @return ApplicationPeriod
     * @throws ModelNotFoundException
     */
    public function getApplicationPeriodFromRegistration($registration)
    {
        $resultSet =
            ApplicationPeriod::find()
            ->innerJoin(
                'academic_offering',
                '`application_period`.`applicationperiodid` = `academic_offering`.`applicationperiodid`'
            )
            ->where(["academicofferingid" => $registration->academicofferingid])
            ->all();
        if ($resultSet == false) {
            throw new ModelNotFoundException(
                "Application period associated with student registration not found."
            );
        } else {
            return $resultSet[0];
        }
    }
}
