<?php

namespace common\models;

class Result
{
    private $value;
    private $isSuccess;
    private $error;

    private function __construct($value, $isSuccess, $error)
    {
        $this->value = $value;
        $this->isSuccess = $isSuccess;
        $this->error = $error;
    }

    public static function success($value)
    {
        return new Result($value, true, null);
    }

    public static function failure($error)
    {
        return new Result(null, false, $error);
    }

    public function isSuccess()
    {
        return $this->isSuccess;
    }

    public function isFailure()
    {
        return !$this->isSuccess;
    }

    public function getValue()
    {
        if (!$this->isSuccess) {
            throw new \Exception('Cannot access value of a failed result.');
        }

        return $this->value;
    }

    public function getError()
    {
        if ($this->isSuccess) {
            throw new \Exception('Cannot access error of a successful result.');
        }

        return $this->error;
    }
}
