<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "re_enrolment".
 *
 * @property string $id
 * @property string $user_id
 * @property string $personnel_id
 * @property string $previous_student_registration_id
 * @property string $new_student_registration_id
 * @property string $comments
 * @property string $date
 * @property integer $is_deleted
 *
 * @property Person $user
 * @property Person $personnel
 * @property StudentRegistration $previousStudentRegistration
 * @property StudentRegistration $newStudentRegistration
 */
class ReEnrolment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 're_enrolment';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'personnel_id', 'previous_student_registration_id', 'new_student_registration_id', 'date', 'is_deleted'], 'required'],
            [['user_id', 'personnel_id', 'previous_student_registration_id', 'new_student_registration_id', 'is_deleted'], 'integer'],
            [['comments'], 'string'],
            [['date'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'personnel_id' => 'Personnel ID',
            'previous_student_registration_id' => 'Previous Student Registration ID',
            'new_student_registration_id' => 'New Student Registration ID',
            'comments' => 'Comments',
            'date' => 'Date',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['personid' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPersonnel()
    {
        return $this->hasOne(User::class, ['personid' => 'personnel_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPreviousStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'previous_student_registration_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNewStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'new_student_registration_id']);
    }
}
