<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "programme_specialisation_type".
 *
 * @property string $id
 * @property string $name
 * @property integer $is_active
 * @property integer $is_deleted
 *
 * @property AcademicOfferingSpecialisation[] $academicOfferingSpecialisations
 */
class ProgrammeSpecialisationType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'programme_specialisation_type';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'name', 'is_active', 'is_deleted'], 'required'],
            [['name'], 'string'],
            [['is_active', 'is_deleted'], 'integer'],
            [['id'], 'string', 'max' => 13],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'is_active' => 'Is Active',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcademicOfferingSpecialisations()
    {
        return $this->hasMany(AcademicOfferingSpecialisation::class, ['programme_specialisation_type_id' => 'id']);
    }
}
