<?php

namespace common\models;

class OfferModel
{
    public static function getOfferById($id)
    {
        return Offer::find()->where(["offerid" => $id])->one();
    }

    public static function getApplication($offer)
    {
        return Application::find()->where(["applicationid" => $offer->applicationid])->one();
    }

    private static function isInterviewOffer($offer)
    {
        if ($offer->offertypeid == 2) {
            return true;
        }
        return false;
    }

    public static function isCustomOffer($offer)
    {
        if (self::isInterviewOffer($offer) == true) {
            return "N/A";
        }

        $application =
            Application::find()
            ->where([
                "applicationid" => $offer->applicationid,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();

        if ($application == false) {
            return "-";
        }

        if ($application->ordering >= 4) {
            return "Yes";
        } else {
            return "No";
        }
    }

    public static function offerFeeStatus($offer)
    {
        $application =
            Application::find()
            ->where([
                "applicationid" => $offer->applicationid,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();

        if ($application == false) {
            return "-";
        }

        $applicant = Applicant::find()
            ->where([
                "personid" => $application->personid,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();

        if ($applicant == false) {
            return "-";
        }

        $applicationFeeOutstanding =
            BillingModel::isApplicationSubmissionFeeOutstanding($applicant);
        if ($applicationFeeOutstanding == true) {
            return "Not Paid";
        }
        return "Paid";
    }

    public static function isCapeOffer($offer)
    {
        $application =
            Application::find()
            ->where([
                "applicationid" => $offer->applicationid,
                "isactive" => 1,
                "isdeleted" => 0
            ])
            ->one();

        return ApplicationModel::isCape($application);
    }

    public static function canPublishModifiedOfferFollowUp($offer)
    {
        if (self::isCustomOffer($offer) == "Yes") {
            return true;
        }
        return false;
    }
}
