<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "graduation_survey".
 *
 * @property string $id
 * @property string $student_registration_id
 * @property string $creator_id
 * @property string $respondent_id
 * @property string $email
 * @property string $send_date
 * @property string $respond_date
 * @property integer $publish_count
 * @property integer $will_participate
 * @property string $billing_charge_id
 * @property integer $is_deleted
 *
 * @property StudentRegistration $studentRegistration
 * @property BillingCharge $billingCharge
 * @property User $creator
 * @property User $respondent
 */
class GraduationSurvey extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'graduation_survey';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['student_registration_id', 'creator_id', 'is_deleted'], 'required'],
            [['student_registration_id', 'creator_id', 'respondent_id', 'publish_count', 'will_participate', 'billing_charge_id', 'is_deleted'], 'integer'],
            [['send_date', 'respond_date'], 'safe'],
            [['email'], 'string', 'max' => 50]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'student_registration_id' => 'Student Registration ID',
            'creator_id' => 'Creator ID',
            'respondent_id' => 'Respondent ID',
            'email' => 'Email',
            'send_date' => 'Send Date',
            'respond_date' => 'Respond Date',
            'publish_count' => 'Publish Count',
            'will_participate' => 'Will Participate',
            'billing_charge_id' => 'Billing Charge ID',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStudentRegistration()
    {
        return $this->hasOne(StudentRegistration::class, ['studentregistrationid' => 'student_registration_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingCharge()
    {
        return $this->hasOne(BillingCharge::class, ['id' => 'billing_charge_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCreator()
    {
        return $this->hasOne(User::class, ['personid' => 'creator_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRespondent()
    {
        return $this->hasOne(User::class, ['personid' => 'respondent_id']);
    }
}
