<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "graduation_package_change_request_status".
 *
 * @property string $id
 * @property string $name
 * @property integer $is_deleted
 *
 * @property GraduationPackageChangeRequest[] $graduationPackageChangeRequests
 */
class GraduationPackageChangeRequestStatus extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'graduation_package_change_request_status';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'is_deleted'], 'required'],
            [['is_deleted'], 'integer'],
            [['name'], 'string', 'max' => 50]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGraduationPackageChangeRequests()
    {
        return $this->hasMany(GraduationPackageChangeRequest::class, ['graduation_package_change_request_status_id' => 'id']);
    }
}
